<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPortfolio extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name = "portfolio";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;


				case "category":
					return $this->Category();
				break;

				case "item":
					return $this->Item();
				break;
				
			}
		}
		
	}


	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"categories"				=> "categories.htm",
			"category"					=> "category.htm",
			"onepage"					=> "onepage.htm",

			"items"						=> "items.htm",

			"item"						=> "item.htm",
			"image"						=> "image.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		switch ($this->tpl_module["settings"]["set_style"]) {
			default:
				return $this->Categories();
			break;

			case "onepage":
				return $this->OnePage();
			break;
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Categories() {
		global $base;

		$text = $this->pageTitleBlock();				
		$this->module->plugins["seo"]->PageMeta($text);


		$template = &$this->private->templates["categories"];

		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]}
			ORDER BY
				c.cat_order ASC
			",
			array( time() )
		);


		$cats = $this->processCats($cats , $template);
		
		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$template,
						"" , 
						$cats
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("MainTitle" , $text) : "",

				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
		
	}
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessCats($cats , $template , $module = null) {

		if (!$module) {
			$module = $this->tpl_module;
		}		


		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$val["link"] = $module["link"] . $val["cat_url"] . "/";
				$cats[$key]["icon"] = $template->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);

				$cats[$key]["button"] = $module["settings"]["set_elements"] == "1" ? $template->blockReplace(
					"Button",
					array(
						"size"	=> $module["settings"]["set_button_size"],
						"style"	=> $style,

						"link"	=> $val["link"] , 
						"text"	=> $btn,
						
					)
				) : "";	

				$cats[$key]["title"] = $template->blockReplace("TitleLink" , $val);

				switch ($val["cat_tn_type"]) {
					//image
					case "1":
						$cats[$key]["image"] = $val["cat_tn_image"] ? $template->blockREplace("TnImageLink" , $val) : "";
					break;

					//icon
					default:
					case "2":
						$cats[$key]["image"] = $template->blockREplace("TnIconLink" , $val);
					break;
				}
				
			}			
		}

		return $cats;
	}




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OnePage() {
		global $base;

		//read all categories
		$cats = $this->getCats();

		$text = $this->PageTitleBlock();
		$this->module->plugins["seo"]->PageMeta($text);

		if (!is_array($cats)) {
			return "";
		}
		

		foreach ($cats as $key => $val) {
			$cond[] = " find_in_set({$val[cat_id]} , item_cat )";
		}			

		$cond = "( " . implode(" OR " , $cond ) . " )";

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_items']} as i,
				{$this->tables['plugin:portfolio_items_lang']} as il
			WHERE 				
				i.item_id=il.item_id AND 
				il.lang_id={$this->tpl_module[lang_id]} AND 
				i.module_id={$this->tpl_module[mod_id]} AND
				item_status = 1 AND {$cond}

			ORDER BY  
				item_order ASC
			"
		);

		if (is_array($items)) {

			$cats_count = count($cats);

			$items = $this->ProcessItems($items, $cats);
			foreach ($items as $key => $val) {
				//$items[$key] = $this->ProcessImage($val);

				if ($cats_count  < 2) {
					$items[$key]["cat_title"] = "";
				}
				
			}			
		}		


		$template = &$this->private->templates["onepage"];

		$this->SetComments($this->tpl_module["settings"]["set_comments_cat"], array("link" => $this->tpl_module["link"]));


		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"cats"	=> count($cats) > 1 ? $base->html->Table(
						$template, 
						"Cats" , 
						$cats
					) : "",

					"items"	=> $base->html->Table(
						$this->_t("items"), 
						"" , 
						$items
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("Title" , $text) : "",

				),
				$text,	
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetCats($module = null) {
		if (!$module) {
			$module = $this->tpl_module;
		}

		$cats = $this->db->QFetchRowArray("
			SELECT * 
			FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$module[lang_id]} AND 
				c.module_id={$module[mod_id]} AND 
				c.cat_status = 1  
			ORDER BY  
				cat_order ASC 
		");

		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$_cats[$val["cat_id"]] = $val;
			}			
		}
		
		return $_cats;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items , $cats = array()) {
		global $base;
		

		$elements = explode("," , $this->tpl_module["settings"]["set_elements_projects"]);
			

		if (is_array($items)) {
			foreach ($items as $key => $val) {				

				$items[$key]["_title"] = $items[$key]["_cats"] = $items[$key]["_brief"] = "";


				if ($val["item_brief"]) {
					$val["item_brief"] = nl2br($val["item_brief"]);

					$items[$key]["_brief"] = $this->_t("items")->blockreplace(
						"Brief",
						$val
					);
				} 				

				if (in_array("title", $elements )) {
					$items[$key]["_title"] = $this->_t("items")->blockReplace("Title" , $val);
				}


				$tmp = explode("," , $val["item_cat"]);
				$_cats = array();

				foreach ($tmp as $k => $v) {
					$tmp[$k] = "cat{$v}";
					$_cats[] = $cats[$v];
				}				


				if (in_array("cats", $elements )) {

					$items[$key]["_cats"] = $base->html->table(
						$this->_t("items"),
						"Cats",
						$_cats
					);

				}

				$items[$key]["cats"] = implode(" " , $tmp);
				$items[$key]["link"] = $val["link"] = $this->tpl_module["link"] . "{$val[item_url]}/{$val[item_id]}";			
				$items[$key]["tn"] = $this->tpl_module["settings"]["set_height_projects"] ? "upload/portfolio/m_{$val[item_id]}.jpg" : "upload/portfolio/{$val[item_id]}.jpg";
			}			
		}
		

		return $items;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Item() {
		global $base;

		$item = $this->db->QFetchArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_items']} as c,
				{$this->tables['plugin:portfolio_items_lang']} as l
			WHERE 				

				c.item_id=l.item_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND  
				l.item_id= %d AND
				c.item_status=1
			",
			array(
				$_GET["item_id"]
			)
		);

		if (!is_array($item)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$item["link"] = $this->tpl_module["link"] . "{$item[item_url]}/{$item[item_id]}";

		$text = $this->PageTitleBlock(array(
			$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
			$item["link"]				=> $item["item_title"]
		));

		$this->module->plugins["seo"]->PageMeta($item);

		$template = &$this->private->templates["item"];

		$this->SetComments($this->tpl_module["settings"]["set_comments_details"], array("link" => $item["link"]));

		$photos = $this->plugins["media"]->Gallery(
			$item["item_id"] , 
			$item["module_id"] , 
			"" , 
			"", 
			"array" , 
			array(
				"path" => "upload/portfolio",
				"tn"	=> $this->tpl_module["settings"]["set_images_height"] ? "tn" : "tn2"
			)
		);	 			

		$item["_images2"] = $item["_images"] = "";
	
		
		if (is_array($photos)) {		
			switch ($item["item_image_type"]) {
				//gallery
				case "1":

					//extract the first photo and use it as the main one
					$main = $photos[0];
					unset($photos[0]);

					if (is_Array($photos)) {
						$item["_images2"] = $this->_t("image")->blockREplace(
							"Gallery",
							array(
								"main"		=> "",

								"images"	=> $base->html->Table(
									$this->_t("image"), 
									"Gallery" , 
									$photos
								)
							),
							$item,
							$this->tpl_module,
							$this->tpl_module["settings"]
						);

						$item["_images"] = $this->_t("image")->blockREplace(
							"GalleryMain",
							$main
						);
					} 


				break;

				//slider
				default:
					$item["_images"] = $base->html->Table(
						$this->_t("image"),
						"Slider",
						$photos
					);
				break;
			}
		} 		

		if ($item["item_specs"]) {
			$tmp = explode("\n" , $item["item_specs"]);
			$_tmp = array();

			foreach ($tmp as $k => $v) {

				$tmp2 = explode("|" , trim($v));

				$_tmp[] = array(
					"title"	=> $tmp2[0],
					"value"	=> $tmp2[1],
				);
			}


			foreach ($_tmp as $key => $val) {
				if (trim($val["value"])){
					$_tmp[$key]["title"] = $template->blockReplace("HeadlineTitle" , $val);
				}
			}


			$item["headline"] = $base->html->table(
				$template,
				"Headline" , 
				$_tmp
			);

		} else {
			$item["headline"] = "";
		}


		if ($item["item_link_type"]) {
			$item["btn_link"] = $this->plugins["modules"]->BuildLink(array(
						"type"	=> $item["item_link_type"],
						"link"	=> $item["item_link_link"],
						"module"=> $item["item_link_module"],
						"global"=> $item["item_link_global"]
					));

			$item["online_butt"] = $template->blockReplace("OnlineButt" , $item);
		} else {
			$item["online_butt"] = "";
		}


		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_item"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockReplace(
				$item["headline"] ? "Main" : "MainNoDetails", 
				$item,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Category() {

		global $base;
		
		$cat = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:portfolio_cats']} as p , 
				{$this->tables['plugin:portfolio_cats_lang']} as l
			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				cat_status = 1 AND
				l.cat_url LIKE '%s'
			",
			array(
				$_GET["cat_url"],
				time()
			)
		);

		if (!is_array($cat)) {
				return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}
		
		$text = $this->pageTitleBlock(array(
			$this->tpl_module["link"]						=> $this->tpl_module["mod_name"],
			$this->tpl_module["link"] . "{$cat[cat_url]}/"	=> $cat["cat_title"]
		));


		$this->plugins["seo"]->PageMeta($cat);
		$this->plugins["seo"]->Canonical($this->tpl_module["link"] . $cat["cat_url"] . "/");

		$items = $this->_GetItemsPage(
			"
				{$this->tables['plugin:portfolio_items']} as p , 
				{$this->tables['plugin:portfolio_items_lang']} as l
			",
			99999 , 
			$_GET["page"],
			"	
				p.item_id = l.item_id and 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				find_in_set({$cat[cat_id]}  , p.item_cat) AND 
				p.item_status = 1
			",
			"item_order ASC"
		);


		$items = $this->ProcessItems($items["records"] , $this->getCats());


		$this->SetComments($this->tpl_module["settings"]["set_comments_cat"], array("link" => $this->tpl_module["link"] . $cat["cat_url"] . "/"));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_cat"],
				$this->tpl_module["mod_protected"]
			),
			$this->_t("category")->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$this->_t("items"), 
						"" , 
						$items,

						array(
							"set_size"		=> $cat["cat_size"],
							"set_size_lg"	=> $cat["cat_size_lg"],
							"set_size_md"	=> $cat["cat_size_md"],
							"set_size_sm"	=> $cat["cat_size_sm"],
							"set_size_xs"	=> $cat["cat_size_xs"],
						)
					),

					"head"	=> in_array("cat" , explode("," , $this->tpl_module["settings"]["set_elements_category_details"])) ? $this->_t("category")->blockReplace("Head" , $cat) : "",

				),
				$cat,
				$text ,
				$this->tpl_module

			)
		);

	}


	function GetMenuButton($module) { 

		if ($module["settings"]["set_style"] == "onepage") {
			$module["settings"]["set_menu_style"] = 0;
		}
	

		switch ($module["settings"]["set_menu_style"]) {
			default:
				return null;//parent::GetMenuButton($module);
			break;

			case "1":
				$items = $this->db->QFetchRowArray(
					"SELECT * " . 
					"FROM 
						{$this->tables['plugin:portfolio_cats']} as i,
						{$this->tables['plugin:portfolio_cats_lang']} as il
					WHERE 				
						i.cat_id = il.cat_id AND 
						il.lang_id={$module[lang_id]} AND 
						i.module_id={$module[mod_id]} AND 
						cat_status = 1 

					ORDER BY  cat_order ASC",
					array(
						time()
					)
				);


				if (is_array($items)) {
					foreach ($items as $key => $val) {
						$sub[] = array(
							"title"		=> $val["cat_title"],
							"link"		=> $module["link"] . $val["cat_url"] . "/ ",
							"selected"	=> ($module["mod_id"] == $val["module_id"] ) && ( $val["cat_url"] == $_GET["cat_url"]) ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					}
				
				}

				return parent::GetMenuButton(
					$module , 
					array( 
						"html"	=> $this->plugins["menus"]->dropDownHTML(								
							array(
								"size"		=> $module["settings"]["set_menu_cols"],
								"id"		=> $module["mod_id"],
								"bg"		=> $module["settings"]["set_menu_bg"],
								"title"		=> $module["mod_name"],
							),
							$sub
						)
					)
				);
			
			break;

		}				
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetLinks($module , &$links) {
		
		$links[] = array(
			"url" => $module["link"],
		);

		if (!in_array($module["settings"]["set_style"] , array("onepage" ))) {	
			$cats = $this->db->QFetchRowArray(

				"SELECT * FROM 
					{$this->tables['plugin:portfolio_cats']} as c,
					{$this->tables['plugin:portfolio_cats_lang']} as l
				WHERE
					c.module_id={$module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					l.lang_id = {$module[lang_id]} 
				ORDER BY
					c.cat_order ASC
				",
				array( time() )
			);

			if (is_array($cats)) {
				foreach ($cats as $key => $val) {
					$links[] = array(
						"url"	=> $module["link"] . $val["cat_url"] . "/"
					);
				}				
			}
		}

		$items = $this->db->QFetchRowArray(
			"SELECT item_url, i.item_id FROM 
				{$this->tables['plugin:portfolio_items']} as i,
				{$this->tables['plugin:portfolio_items_lang']} as il
			WHERE 				
				i.item_id=il.item_id AND 
				il.lang_id={$module[lang_id]} AND 
				i.module_id={$module[mod_id]} AND
				item_status = 1
			ORDER BY  
				item_date DESC
			"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"url"	=> $module["link"] . "{$val[item_url]}/{$val[item_id]}"			
				);
			}			
		}
		
	}

}

?>