<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CJobs extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
		$this->namd = "jobs";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "jobs") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "detect":
					return $this->Landing();
				break;

				case "category":
					return $this->Category();
				break;



				case "landing":
					return $this->Landing();
				break;

				case "ajax.upload":
					return $this->AjaxUpload();
				break;

				case "ajax.send":
					return $this->AjaxSend();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(

			"categories"			=> "categories.htm",
			"category"				=> "category.htm",
			"onepage"				=> "onepage.htm",
			"items"					=> "items.htm",



			"list"					=> "list.htm",
			"form"					=> "form.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		switch ($this->tpl_module["settings"]["set_style"]) {
			//categories listing
			default:
				return $this->Categories();
			break;

			//skip listing
			case "1":
				$this->Detect();
				return $this->Category();
			break;

		}
		
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Categories() {
		global $base;

		$text = $this->pageTitleBlock();				
		$this->module->plugins["seo"]->PageMeta($text);


		$template = &$this->private->templates["categories"];

		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:jobs_cats']} as c,
				{$this->tables['plugin:jobs_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND
				cat_date < %d

			ORDER BY
				c.cat_order ASC
			",
			array( time() )
		);


		$cats = $this->ProcessCats($cats , $template);
		
		$this->SetComments($this->tpl_module["settings"]["set_comments"] , array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$template,
						"" , 
						$cats
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("MainTitle" , $text) : "",
					"_head"		=> $text["text_block_1_header"] ? $template->blockReplace("Head" , $text) : "",

				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
		

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Category() {

		global $base;

		$cat = $this->GetCatByUrl($_GET["cat_url"]);

		
		$text = $this->pageTitleBlock(array(
			$this->tpl_module["link"]						=> $this->tpl_module["mod_name"],
			$this->tpl_module["link"] . "{$cat[cat_url]}/"	=> $cat["cat_title"]
		));


		if (!is_array($cat)) {

			if ($this->detected) {
				return "";
			} else {		
				return $this->module->plugins["redirects"]->ErrorPage("404" , true);
			}
		}


		$this->plugins["seo"]->PageMeta($cat);
		$this->plugins["seo"]->Canonical($this->tpl_module["link"] . $cat["cat_url"] . "/");

		$types = array("1");

		if ($this->tpl_module["settings"]["set_archive"]) {
			$types[] = 3;
		}

		if ($this->tpl_module["settings"]["set_closed"]) {
			$types[] = 2;
		}		
			
		$items = $this->GetItems($cat , implode("," , $types));
		$items = $this->ProcessItems($items , $cat);

		
		$this->SetComments($this->tpl_module["settings"]["set_comments_details"], array("link" => $this->tpl_module["link"] . $cat["cat_url"] . "/"));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_details"],
				$this->tpl_module["mod_protected"]
			),
			$this->_t("category")->blockREplacE(
				"Main" , 
				array(
					"open"	=> is_array($items[1]) ? $this->_t("category")->blockReplace(
						"Open",
						array(
							"items"	=> $base->html->table(
								$this->_t("items"),
								"",
								$items[1]
							),

							"_title"	=> $this->tpl_module["settings"]["lang_open"] ? $this->_t("category")->blockReplace(
								"TypeTitle",
								array("title" => $this->tpl_module["settings"]["lang_open"])
							) : "",
						)
					) : "",


					"closed"	=> is_array($items[2]) ? $this->_t("category")->blockReplace(
						"Closed",
						array(
							"items"	=> $base->html->table(
								$this->_t("items"),
								"",
								$items[2]
							),
							"_title"	=> $this->tpl_module["settings"]["lang_closed"] ? $this->_t("category")->blockReplace(
								"TypeTitle",
								array("title" => $this->tpl_module["settings"]["lang_closed"])
							) : "",

						)
					) : "",

					"archive"	=> is_array($items[3]) ? $this->_t("category")->blockReplace(
						"Archive",
						array(
							"items"	=> $base->html->table(
								$this->_t("items"),
								"",
								$items[3]
							),
							"_title"	=> $this->tpl_module["settings"]["lang_archived"] ? $this->_t("category")->blockReplace(
								"TypeTitle",
								array("title" => $this->tpl_module["settings"]["lang_archived"])
							) : "",

						)
					) : "",


//					"form"	=> $this->Form($this->tpl_module , $cat),


					"_title"	=> $this->tpl_module["settings"]["set_title"] ? $this->_t("category")->blockReplace("Title" , $cat) : "",
					"_head"		=> $cat["cat_description"] ? $this->_t("category")->blockReplace("Head" , $cat) : "",

				),
				$cat,
				$this->tpl_module,
				$this->tpl_module["settings"]		
			)
		);

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items) {

		if (is_array($items)) {
			$elements = array(				
				"1" => explode("," , $this->tpl_module["settings"]["set_elements_1"]),
				"2"	=> explode("," , $this->tpl_module["settings"]["set_elements_2"]),
				"3"	=> explode("," , $this->tpl_module["settings"]["set_elements_3"])
			);

			foreach ($items as $key => $val) {

				$items[$key]["_fax"] = $items[$key]["_phone"] = $items[$key]["_email"] = $items[$key]["_location"] = $items[$key]["_person"] = $items[$key]["_left"] = $items[$key]["_applicants"] = "";


				if (in_array("contact" , $elements[$val["item_status"]])) {
					$items[$key]["_person"] = $val["item_contact"] ? $this->_t("items")->blockREplace("person" , $val) : "";
				}

				if (in_array("email" , $elements[$val["item_status"]])) {
					$items[$key]["_email"] = $val["item_email"] ? $this->_t("items")->blockREplace("email" , $val) : "";
				}
				
				if (in_array("phone" , $elements[$val["item_status"]])) {
					$items[$key]["_phone"] = $val["item_phone"] ? $this->_t("items")->blockREplace("phone" , $val) : "";
				}

				if (in_array("fax" , $elements[$val["item_status"]])) {
					$items[$key]["_fax"] = $val["item_fax"] ? $this->_t("items")->blockREplace("fax" , $val) : "";
				}

				if (in_array("location" , $elements[$val["item_status"]])) {
					$items[$key]["_location"] = $val["item_location"] ? $this->_t("items")->blockREplace("location" , $val) : "";
				}

				if (in_array("applicants" , $elements[$val["item_status"]])) {
					$cnt = $this->db->RowCount($this->tables['plugin:jobs_resumes'] , "WHERE item_job={$val[item_id]}");

					$items[$key]["_applicants"] = $this->_t("items")->blockReplace(
						$cnt ? "Applicants" : "NoApplicants", 
						array(
							"count"	=> $cnt
						)
					);
				}

				if (in_array("time" , $elements[$val["item_status"]])) {
					if ($val["item_date_expire"] > time()) {
						$items[$key]["_left"] = $this->_t("items")->blockReplace(
							"Left",
							array(
								"left"	=> CDate::Friendly($val["item_date_expire"])
							)
						);
					}
				}

				$items[$key]["_icon"] = $this->_t("items")->blockReplace($val["item_icon"] ? "Icon" : "NoIcon" , $val);
				
				
			}
			
			foreach ($items as $key => $val) {
				$_items[$val["item_status"]][] = $val;
			}			
		}
		

		return $_items;
	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Form($module ,  $widget = false , $job = null , $cat) {

		global $_LANG_ID , $_SESS , $_LANG_CODE , $base;

		$template = $this->private->templates["form"];
				
		//prepare the fields
		$fields = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:jobs_fields']} as f,
				{$this->tables['plugin:jobs_fields_lang']} as l
			WHERE 
				f.module_id={$module[mod_id]} AND 
				f.item_id = l.item_id AND 
				(item_cat = '' OR find_in_set(%d, item_cat)) AND 
				l.lang_id = {$_LANG_ID} {$cond}
			ORDER BY 
				item_order ASC",
			array(
				$cat["cat_id"]
			)
		);

		$_fields = array(
			array(
				"type"		=> "hidden",
				"name"		=> "cat",
				"default"	=> $cat["cat_id"]
			)
		);

		if (is_array($fields)) {
			$cnt = 1;

			$types = array(
				"userjobs"	=> "select",
				"userdroplist"	=> "select",
				"userradio"	=> "radiolist",
				"usercheck"	=> "checklist",
				"usertext"		=> "textbox",
				"useremail"		=> "textbox",
				"usermessage"	=> "textarea",
				"calendar"		=> "calendar",
				"calendartime"	=> "calendar",
				"time"			=> "calendar",
				"subtitle"		=> "title",
			);

			foreach ($fields as $key => $val) {

				$field = array(
					"type"		=> $types[$val["item_type"]],
					"title"		=> $val["item_title"],
					"name"		=> $val["item_field"],
					"required"	=> $val["item_required"],
					"default"	=> $_GET[$val["item_field"]],
					"size"		=> array(
						"xl"		=> $val["item_size"],
						"lg"		=> $val["item_size_lg"],
						"md"		=> $val["item_size_md"],
						"sm"		=> $val["item_size_sm"],
						"xs"		=> $val["item_size_xs"],
					)
				);

				switch ($val["item_type"]) {

					case "calendar":
						$field["calendar"]	= array("type" => "date");
					break;

					case "calendartime":
						$field["calendar"]	= array("type" => "full");
					break;

					case "time":
						$field["calendar"]	= array("type" => "time");
					break;

					case "userjobs":

						$jobs = $this->GetItems($cat, 1);

						if (is_array($jobs)) {
							foreach ($jobs as $_key => $_val) {
								$field["options"][$_val["item_id"]] = $_val["item_title"];
							}							
							$field["default"] = $_GET["job_id"];
						 } else {
							 return "";
						 }


					break;

					case "userradio":
					case "usercheck":
					case "userdroplist":
							$tmp = @explode("\n" , $val["item_options"]);
							foreach ($tmp as $k => $v) {
								$v = explode("|" , $v);
								$v[0] = trim($v[0]);

								if ($v[0]) {									
									$field["options"][$v[0]] = $v[0];

									if ($v[1] == "1") {
										$field["default"] = $v[0];
									}
								}
							}

							if ($val["item_radio_new"]) {
								$field[$field["type"]] = array("newline" => true);							
							}
							
					break;
				}

				if (is_array($field)) {
					$_fields[] = $field;
				}								
			}


			//append upload
			if ($module["mod_settings"]["set_uploader"]) {
				$_fields[] = array(
					"type"		=> "upload",
					"title"		=> $module["mod_settings"]["lang_uploader_field"],
					"name"		=> "files",
					"required"	=> "",

					"upload"	=> array(
						"url"	=> $this->plugins["modules"]->ScriptLink("ajax.jobs-upload.php" , array("module_id" => $this->tpl_module["mod_id"])),
						"files"	=> $this->tpl_module["settings"]["set_uploader_extensions"],
						"size"	=> $this->tpl_module["settings"]["set_uploader_filesize"] * 1000000
					),
				);

				/*
				$_fields[] = array(
					"type"		=> "custom",
					"title"		=> $module["mod_settings"]["lang_uploader_field"],
					"name"		=> "upload",
					"required"	=> "",
					"custom"	=> $template->blockReplace("Upload" , $mdule["mod_settings"]),
				);
				*/
				
			}

			

			return CTemplateStatic::Replace(
				$template->blockReplace(
					"Form", 
					array(
						"script"	=> $this->plugins["modules"]->ScriptLink("ajax.jobs-send.php" , array("module_id" => $module["mod_id"] )),
						"JOB_ID"	=> $job["item_id"],

						"form"	=> 	formBuilder::newInstance()
							-> setFields($_fields)
							-> setCaptcha(array(
								"type"	=> $module[$widget ? "mod_settings" : "settings"]["set_post_capcha"] ,
								"name"	=> "resume",
							))
							-> buildFields(),
					)
				),
				array(
					"token"		=> md5($_SERVER["REMOTE_ADDR"]),
					"MOD_ID"	=> $module["mod_id"],

				)
			);

		}
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AjaxUpload() {
		global $_CONF;

		$this->__init();

		if (!is_array($this->tpl_module)) {
			return "Unknown error";
		}

		External::Load("fileupload");
		$upload_handler = new UploadHandler(
			array(
				"param_name"		=> "files",
				'upload_dir'		=> "./upload/tmp/",
				'upload_url'		=> $_CONF["url"] . "upload/tmp/",
				"accept_file_types"	=> '/\.(' . str_replace(',' , '|' , $this->tpl_module["settings"]["set_uploader_extensions"]) . ')$/i',
//				"max_file_size"		=> ($this->tpl_module["settings"]["set_uploader_filesize"] * 1000000),
			)							
		);

		die();


		$types = $this->tpl_module["settings"]["set_uploader_extensions"];

		if (!$types) {
			return "Please configure the allowed extensions!";
		}

		$types = explode("," , $types);

		if (count($types)) {
			foreach ($types as $key => $val) {
				$fileTypes[] = trim($val);
			}			
		}
		
		$verifyToken = md5($_SERVER["REMOTE_ADDR"]);

		if (!empty($_FILES) && $_POST['token'] == $verifyToken) {
				$tempFile   = $_FILES['Filedata']['tmp_name'];
				$uploadDir  = $_CONF["upload"] . "tmp/";
				$targetFile = $uploadDir . $_POST["token"] . "_" . $_FILES['Filedata']['name'];

				// Validate the filetype
				$fileParts = pathinfo($_FILES['Filedata']['name']);
		
				if (in_array(strtolower($fileParts['extension']), $fileTypes)) {
					// Save the file
					move_uploaded_file($tempFile, $targetFile);
					return 1;
			} else {
				return $this->tpl_module["settings"]["lang_error_file"];
			}
		}
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AjaxSend() {
		global $_CONF , $_NO_HTACCESS , $_SESS , $_LANG_ID;


		$this->__init();

		if (!is_array($this->tpl_module)) {
			return "Unknown error";
		}

		$response = CFormError::newInstance()
			->SetErrorStyle($this->tpl_module["settings"]["set_form_validate"])
			->SetSuccessStyle($this->tpl_module["settings"]["set_form_success"])
			->SetSuccessRedirect($this->plugins["modules"]->BuildLink(array(
					"type"	=> $this->tpl_module["settings"]["set_form_link_type"],
					"link"	=> $this->tpl_module["settings"]["set_form_link_link"],
					"module"=> $this->tpl_module["settings"]["set_form_link_module"],
					"global"=> $this->tpl_module["settings"]["set_form_link_global"]
			)))
			->SetPopupBtn($this->tpl_module["settings"]["lang_popup_close"])
			->SetPopupBg($this->tpl_module["settings"]["set_form_popup_bg"]);

		//prepare the fields
		$fields = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:jobs_fields']} as f,
				{$this->tables['plugin:jobs_fields_lang']} as l
			WHERE 
				(item_cat = '' OR find_in_set(%d, item_cat)) AND 
				f.module_id={$this->tpl_module[mod_id]} AND
				f.item_id = l.item_id AND 
				l.lang_id = {$_LANG_ID}
			ORDER BY 
				item_order ASC",
			array(
				$_POST["cat"]
			)
		);
		

		if (is_array($fields)) {
			foreach ($fields as $key => $val) {

				if ($val["item_field"] == "email") {

					if (!Validate::Email($_POST["email"])) {
						$response->AddField("email" , $val["item_error_msg"]);
					} else {
						if (!$this->plugins["antispam"]->ValidateEmail($this->tpl_module, $_POST["email"])) {
							$response->AddField("email" , $this->plugins["antispam"]->EmailError());
						}
					}

				} else {				
					if ($val["item_required"] && !$_POST[$val["item_field"]]) {
						$response->AddField($val["item_field"] , $val["item_error_msg"]);
					}
				}
			}			
		}

		if (!$this->plugins["antispam"]->ValidateEmail($this->tpl_module,$_POST["email"])) {
			$response->AddField("email" , $this->plugins["antispam"]->EmailError());
		}

		if (!$this->plugins["antispam"]->ValidateClient($this->tpl_module)) {
			$response->AddField("__global" , $this->plugins["antispam"]->ClientError());
		}

		if (!$this->plugins["antispam"]->ValidateCaptcha($this->tpl_module["settings"]["set_post_capcha"] , "resume")) {
			$response->AddField("image_code" , $this->plugins["antispam"]->CaptchaError());
		}


		if ($response->HasErrors()) {
			return $response->GetJson();
		}


		$vars = $_POST;



		foreach ($vars as $key => $val) {
			if (!in_array($key , array("job" , "image_code"))) {
				$message .= "<b>" . ucwords(str_replace("_" , " " , $key)) . "</b>: {$val}<br>";
			}
			
		}

		if (!$vars["message"]) {
			$vars["message"] = $message;
		}
		
		

		if ((int)$_POST["job"]) {
			$job = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:jobs_items']} as i,
					{$this->tables['plugin:jobs_items_lang']} as il
				WHERE
					i.item_id = il.item_id AND 
					il.lang_id = {$this->tpl_module[lang_id]} AND 
					i.item_id = %d" ,						
				array($_POST["job"])
			);
		} 


		//save the email to database
		$id = $this->db->QueryInsert(
			$this->tables["plugin:jobs_resumes"],
			$contact = array(
				"module_id"		=> $this->tpl_module["mod_id"],
				"item_new"		=> 1,
				"item_date"		=> time(),
				"item_email"	=> $vars["email"],
				"item_name"		=> ($vars["name"] ? $vars["name"] : $vars["first_name"] . " " . $vars["last_name"] ),

				"item_job"		=> $_POST["job"],
				"item_message"	=> $message,

				"item_code"		=> md5(microtime_float()),
				"item_vars"		=> serialize($vars),

				"log_ip"			=> $_SERVER["REMOTE_ADDR"],
				"log_domain"		=> $_SERVER["REMOTE_HOST"],
				"log_agent"			=> $_SERVER["HTTP_USER_AGENT"],


			)
		);


		
		if ($vars["files_files"]) {
			$file = $_CONF["upload"] . "tmp/" . $_POST["files_token"] . "_" . $_POST["files_files"];

			if (file_exists($file)) {
				rename (
					$file , 
					$_CONF["upload"] . "jobs/files/" . $id . ".file"
				);

				//update the file
				$this->db->QueryUpdate(
					$this->tables["plugin:jobs_resumes"],
					array(
						"item_file"			=> "1",
						"item_file_file"	=> $_POST["files_files"],
					),
					"item_id={$id}"
				);
			}


			if ($this->tpl_module["settings"]["set_attach"] == "1") {
				$attach[$_POST["files_files"]] = $_CONF["upload"] . "jobs/files/" . $id . ".file";
			}
			
			
		}
		

		$mail_template = $this->module->plugins["mail"]->GetMail(
			$this->tpl_module["settings"]["set_mail_admin"],
			array_merge(
				$vars,
				(array)$job
			)
		);


		$isSpam = $this->plugins["antispam"]->isSpam(
			$this->tpl_module,
			array(
				"type"		=> "message",
				"author"	=> $contact["item_name"],
				"email"		=> $contact["item_email"],
				"message"	=> $contact["item_message"],
			)
		);


		$mail_template["attachments"] = $attach;

		if (is_array($mail_template)) {

			if (!$isSpam) {
				$email = $this->module->plugins["mail"]->SendMail(
					$mail_template
				);			
			}

		}
		
		//check if it is an anonymouse message and do nothing if that is the case
		if ($this->tpl_module["settings"]["set_anonymous"]) {

		} else {		

			$responder_template = $this->module->plugins["mail"]->GetMail(
				$this->tpl_module["settings"]["set_mail_client"],
				array_merge(
					$vars,
					(array)$job
				)
			);

			if (is_array($responder_template)) {

				if (!$isSpam) {

					$email = $this->module->plugins["mail"]->SendMail(
						$responder_template
					);			
				}
			}			
		}		

		return $response->SetReset()
			->SetSuccess($this->tpl_module["settings"]["lang_success"])
			->GetJson();
	}
	




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetItems($cat , $types) {
		return $this->db->QFetchRowArray("
			SELECT * FROM
				{$this->tables['plugin:jobs_items']} as c,
				{$this->tables['plugin:jobs_items_lang']} as l
			WHERE 
				c.item_id=l.item_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.item_status in ( %s ) AND 
				c.item_cat = %d AND

				c.item_date < %d
			ORDER BY  item_order ASC ",
			array(
				$types , 
				$cat["cat_id"],
				time(),			
			)
		);

	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessCats($cats , $template , $module = null) {

		if (!$module) {
			$module = $this->tpl_module;
		}		


		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$val["link"] = $module["link"] . $val["cat_url"] . "/";
				$cats[$key]["icon"] = $template->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);

				$cats[$key]["button"] = $module["settings"]["set_elements"] == "1" ? $template->blockReplace(
					"Button",
					array(
						"size"	=> $module["settings"]["set_button_size"],
						"style"	=> $style,

						"link"	=> $val["link"] , 
						"text"	=> $btn,
						
					)
				) : "";	

				$cats[$key]["title"] = $template->blockReplace("TitleLink" , $val);

				$cats[$key]["image"] = "";

				switch ($val["cat_tn_type"]) {
					//image
					case "1":
						$cats[$key]["image"] = $val["cat_tn_image"] ? $template->blockREplace("TnImageLink" , $val) : "";
					break;

					//icon
					default:
					case "2":
						$cats[$key]["image"] = $val["cat_tn_icon"] ? $template->blockREplace("TnIconLink", $val) :"";
					break;
				}
				
			}			
		}

		return $cats;
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Detect() {
		$cat = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:jobs_cats']} as p , 
				{$this->tables['plugin:jobs_cats_lang']} as l

			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				cat_status = 1 
			ORDER BY 
				cat_order ASC
			LIMIT 1"
		);

		
		$_GET["cat_url"] = $cat["cat_url"];

		$this->detected = true;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetCatByUrl($url , $mod_id = 0) {
		global $_LANG_ID;

		if (!$mod_id) {
			$mod_id = $this->tpl_module["mod_id"];
		}
		

		$cat = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:jobs_cats']} as p , 
				{$this->tables['plugin:jobs_cats_lang']} as l

			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$_LANG_ID} AND 
				p.module_id = %d AND 
				cat_status = 1 AND 
				cat_url LIKE '%s'
			ORDER BY 
				cat_order ASC
			LIMIT 1",
			array(
				$mod_id,
				$url , 
			)
		);

		return $cat;
		
	}
	
	

	function GetMenuButton($module) { 

		switch ($module["settings"]["set_menu_style"]) {
			default:
				return parent::GetMenuButton($module);
			break;

			case "2":

				if ($module["settings"]["set_menu_cats"]) {
					$cond = " AND i.cat_id IN (" . $module["settings"]["set_menu_cats"] . ")";
				}
				
			case "1":
				$items = $this->db->QFetchRowArray(
					"SELECT * " . 
					"FROM 
						{$this->tables['plugin:jobs_cats']} as i,
						{$this->tables['plugin:jobs_cats_lang']} as il
					WHERE 				
						i.cat_id = il.cat_id AND 
						il.lang_id={$module[lang_id]} AND 
						i.module_id={$module[mod_id]} AND 
						cat_status = 1 
						{$cond}
					ORDER BY  cat_order ASC"
				);


				if (is_array($items)) {
					foreach ($items as $key => $val) {
						$sub[] = array(
							"title"		=> $val["cat_title"],
							"link"		=> $module["link"] . $val["cat_url"] . "/ ",
							"selected"	=> ($module["mod_id"] == $val["module_id"] ) && ( $val["cat_url"] == $_GET["cat_url"]) ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					}
				
				}

				return parent::GetMenuButton(
					$module , 
					array( 
						"html"	=> $this->plugins["menus"]->dropDownHTML(								
							array(
								"size"		=> $module["settings"]["set_menu_cols"],
								"id"		=> $module["mod_id"],
								"bg"		=> $module["settings"]["set_menu_bg"],
								"title"		=> $module["mod_name"],
							),
							$sub
						)
					)
				);
			
			break;

		}				
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}


	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		$cats = $this->db->QFetchRowArray(

			"SELECT * FROM 
				{$this->tables['plugin:jobs_cats']} as c,
				{$this->tables['plugin:jobs_cats_lang']} as l
			WHERE
				c.module_id={$module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$module[lang_id]} 
			ORDER BY
				c.cat_order ASC
			",
			array( time() )
		);

		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$links[] = array(
					"url"	=> $module["link"] . $val["cat_url"] . "/"
				);
			}				
		}

	}

}

?>