DROP TABLE IF EXISTS `site_plugin_cta`;
CREATE TABLE `site_plugin_cta` (
  `cta_id` int(11) NOT NULL AUTO_INCREMENT,
  `cta_default` int(1) NOT NULL,
  `cta_modules` text NOT NULL,
  `cta_modules_global` text NOT NULL,
  `cta_link_target` varchar(20) NOT NULL,
  `cta_link_module` int(11) NOT NULL,
  `cta_image` int(11) NOT NULL,
  `cta_status` int(1) NOT NULL,
  `cta_name` varchar(255) NOT NULL,
  `cta_device` varchar(255) NOT NULL,
  `cta_bg` int(11) NOT NULL,
  `cta_bg_style` int(1) NOT NULL,
  `cta_perm` int(11) NOT NULL,
  `cta_perm_groups` text NOT NULL,
  `cta_position` int(1) NOT NULL,
  `cta_type` int(1) NOT NULL,
  `cta_link_global` int(11) NOT NULL,
  `cta_link_size` varchar(10) NOT NULL DEFAULT 'btn-small',
  `cta_link2_type` int(1) NOT NULL,
  `cta_link2_module` int(11) NOT NULL,
  `cta_link2_global` int(11) NOT NULL,
  `cta_link2_size` varchar(10) NOT NULL,
  `cta_link2_target` varchar(20) NOT NULL,
  `cta_link_rel` varchar(30) NOT NULL,
  `cta_link2_rel` varchar(30) NOT NULL,
  `cta_link_style` varchar(50) NOT NULL,
  `cta_link2_style` varchar(50) NOT NULL,
  `cta_css_block` varchar(100) NOT NULL,
  `cta_css_image` varchar(100) NOT NULL,
  `cta_css_content` varchar(100) NOT NULL,
  `cta_css_buttons` varchar(100) NOT NULL,
  PRIMARY KEY (`cta_id`),
  KEY `cta_default` (`cta_default`),
  KEY `cta_status` (`cta_status`),
  KEY `cta_device` (`cta_device`),
  KEY `cta_perm` (`cta_perm`),
  KEY `cta_position` (`cta_position`),
  FULLTEXT KEY `cta_modules` (`cta_modules`),
  FULLTEXT KEY `cta_modules_global` (`cta_modules_global`),
  FULLTEXT KEY `cta_perm_groups` (`cta_perm_groups`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_cta_lang`;
CREATE TABLE `site_plugin_cta_lang` (
  `cta_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `cta_title` text NOT NULL,
  `cta_text` text NOT NULL,
  `cta_link_text` varchar(50) NOT NULL,
  `cta_link_type` int(1) NOT NULL,
  `cta_link_link` varchar(255) NOT NULL,
  `cta_image_alt` varchar(255) NOT NULL,
  `cta_html` text NOT NULL,
  `item_link2_text` varchar(255) NOT NULL,
  `item_link2_link` text NOT NULL,
  `cta_link2_text` varchar(255) NOT NULL,
  `cta_link2_link` text NOT NULL,
  KEY `cta_id` (`cta_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

