<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CGallery extends CPlugin{
	
	var $tplvars; 

	function CGallery() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "gallery") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":

					if ($this->tpl_module["settings"]["set_style"] == "onepage") {
						return $this->OnePage();
					}
					

					return $this->Albums();
				break;

				case "album":
					return $this->Album();
				break;

				case "photo":
					return $this->Photo();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"onepage"				=> "onepage.htm",

			"albums"				=> "albums.htm",
			"album"					=> "album.htm",
			"photo"					=> "photo.htm",

			"widget.photos"			=> "widget.photos.htm",
			"widget.album"			=> "widget.album.htm",
			"widget.albums"			=> "widget.albums.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Albums() {
		global $base;


		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);


		$albums = $this->GetAlbums(array(
			"items" => $this->tpl_module["settings"]["set_ipp_albums"] , 
			"page" => $_GET["page"]
		));

		$albums["records"] = $this->ProcessAlbums($albums["records"]);



		$template = &$this->private->templates["albums"];
	
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);
		
		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$albums["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$albums["pages"] , 
						$albums["page"] , 
						array(
							"first"	=> $this->tpl_module["link"],
							"all"	=> $this->tpl_module["link"] . "p{PAGE}",
						),
						$topics["items"]
					),

					"text_title"	=> $text["text_title"],
					"text_header"	=> $text["text_header"],

				),
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);


	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Album() {
		global $base;
		
		$album = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:gallery_cats']} as p , 
				{$this->tables['plugin:gallery_cats_lang']} as l

			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				p.cat_id='{$_GET[cat_id]}'
			"
		);

		if (!is_array($album)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}
			
		$text = $this->GetTexts();

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
				$this->tpl_module["link"] . "{$album[cat_url]}-{$album[cat_id]}/"	=> $album["cat_title"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);

		$this->module->plugins["seo"]->PageMeta(
			$album
		);

		$images = $this->GetImages(array(
			"items"		=> $this->tpl_module["settings"]["set_ipp_photos"] , 
			"page"		=> $_GET["page"],
			"item_cat"	=> $album["cat_id"]
		));

		$images["records"] = $this->ProcessImages($images["records"] , $album);

		$template = &$this->private->templates["album"];

		if (is_array($images["records"])) {
			foreach ($images["records"] as $key => $val) {
				$images["records"][$key]["title"] = $this->tpl_module["settings"]["set_show_title"] ? $template->blockReplace("Title" , $val )  : "";
				$images["records"][$key]["likes"] = "";
			}			
		}	

		if ($this->plugins["comments"]) {
			$album["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"] . "{$album[cat_url]}-{$album[cat_id]}/",
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$album["comments"] = "";
		}


		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_album"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$images["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$images["pages"] , 
						$images["page"] , 
						array(
							"first"	=> $this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/",
							"all"	=> $this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/p{PAGE}",
						),
						$images["items"]
					),

					"social_links" => $this->plugins["socialmedia"] ? $this->plugins["socialmedia"]->Share($this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/") : ""

				),
				$album,
				$this->tpl_module["settings"],
				$this->tpl_module
			)
		);


	}

	
	/**
	* description

	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetAlbums($params = array()) {
	
		$count	= $params["items"];
		$page	= $params["page"];

		$order		= "cat_date";
		$order_mode = "DESC";

		$cond = "c.cat_id=l.cat_id AND l.lang_id={$this->tpl_module[lang_id]} AND c.module_id={$this->tpl_module[mod_id]} AND c.cat_status = 1 AND c.cat_date <= timestamp(now()) AND c.cat_images > 0  ";

				
		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			",
			"	WHERE {$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}
	


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessAlbums($items) {

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$items[$key]["link"] = $this->tpl_module["link"] . $val["cat_url"] .  "-" . $val["cat_id"] . "/";
				$items[$key]["dl_butt"] =  "";
				$items[$key]["date"] = date($this->tpl_module["settings"]["set_date_album"] , $val["cat_date"]);
				
			}
			
		}
		

		return $items;
	}

	

	function GetImages($params = array()) {
	
		$count	= $params["items"];
		$page	= $params["page"];

		$order		= "item_order";
		$order_mode = "ASC";

		$cond = "c.item_cat={$params[item_cat]} AND c.item_id=l.item_id AND l.lang_id={$this->tpl_module[lang_id]} AND c.module_id={$this->tpl_module[mod_id]} AND item_show=1  ";

		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:gallery_images']} as c,
				{$this->tables['plugin:gallery_images_lang']} as l
			",
			"	WHERE {$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_images']} as c,
				{$this->tables['plugin:gallery_images_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessImage($item) {
		switch ($item["item_type"]) {
			//image
			case "1":
				$item["source"] = "upload/gallery/photos/{$item[item_id]}.jpg";
			break;

			//youtube
			case "2":
				$item["source"] = "https://www.youtube.com/watch?v=" . $item["item_video"];
			break;

			//vimeo
			case "3":
				$item["source"] = "http://www.vimeo.com/" . $item["item_video"];
			break;

		}

		if ($this->tpl_module["settings"]["set_images_height"]) {
			$item["tn"] = "upload/gallery/photos/tn2_{$item[item_id]}.jpg";
		} else {
			$item["tn"] = "upload/gallery/photos/tn_{$item[item_id]}.jpg";
		}

		return $item;
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessImages($items , $album) {

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$items[$key]["link"] = $this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/" . $val["item_id"];

				//$items[$key]["source"] = "";

				$items[$key] = $this->ProcessImage($items[$key]);

				//$items[$key]["dl_butt"] =  "";
				//$items[$key]["date"] = date($this->tpl_module["settings"]["set_date_album"] , $val["cat_date"]);
				
			}
			
		}
		

		return $items;
	}

	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {

			//latest photos
			case "1":
				return $this->widgetPhotos($widget , true);
			break;

			//latest photos from album
			case "2":
				return $this->widgetPhotos($widget);
			break;

			//featured album
			case "3":
				return $this->widgetAlbum($widget);
			break;

			case "4":
				return $this->widgetAlbums($widget);


		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetPhotos($widget , $all = false) {

		if ($all) {
		} else {
			$cond = "AND c.cat_id = {$widget[settings][set_album]}";

		}

		switch ($widget["settings"]["set_order"]) {
			case "1":
				$order = " rand() ";
			break;

			default:
			case "2":
				$order = " i.item_id DESC ";
			break;
			
			case "3":
				$order = " i.item_id ASC ";
			break;
		}
		
		
		$photos = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as cl,
				{$this->tables['plugin:gallery_images']} as i,
				{$this->tables['plugin:gallery_images_lang']} as il
			WHERE
				c.cat_id = cl.cat_id AND
				i.item_id = il.item_id AND 
				c.cat_id = i.item_cat AND
				cl.lang_id = il.lang_id AND
				c.module_id = {$widget[mod_id]} AND
				cl.lang_id = {$widget[lang_id]}
				{$cond}
				
			ORDER BY 
				{$order}
			LIMIT 
				{$widget[settings][set_items]}
			"
		);

		if (is_Array($photos)) {
			foreach ($photos as $key => $val) {
				$photos[$key] = $this->ProcessImage($val);
			}
			

			global $base;

			$template = &$this->private->templates["widget.photos"];

			return $template->blockReplace(
				"Main" , 
				array(
					"title"		=> $widget["widget_name"],
					"images"	=> $base->html->Table(
						$template , 
						"",
						$photos
					)
				),
				$widget["settings"],
				$widget
			);

			
		}
		

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetAlbum($widget) {
		$this->__init();


		$album = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:gallery_cats']} as p , 
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$widget[lang_id]} AND 
				p.module_id = {$widget[mod_id]} AND 
				p.cat_id='{$widget[settings][set_album]}'
			"
		);

		if (!is_array($album)) {
			return "";
		}

		$this->__init();

		$template = &$this->private->templates["widget.album"];

		$album["link"] = $widget["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/";
		$album["date"] = date("F j Y", $album["cat_date"]);

		
		return CTemplateStatic::REplace(
			$template->blockReplace(
				"Main" , 
				$album
			),
			array(
				"title"	=> $widget["widget_name"],
			)
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetAlbums($widget) {
		global $_LANG_ID , $base;

		$labels = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:gallery_cats']} as p , 
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE 
				p.cat_status = 1 AND 
				p.cat_date <= timestamp(now()) AND
				p.cat_images > 0 AND
				p.cat_id = l.cat_id AND 
				l.lang_id = {$widget[lang_id]} AND 
				p.module_id = {$widget[mod_id]} 


			ORDER BY 
				cat_order ASC
			"
		);


		if (is_array($labels)) {

			foreach ($labels as $key => $val) {
				
				$labels[$key]["link"] = $widget["link"] . "{$val[cat_url]}	-{$val[cat_id]}/";
			}

			$template = $this->private->templates["widget.albums"];

			return $template->blockreplace(
				"Main" , 
				array(
					"labels"	=> $base->html->Table(
						$template , 
						"", 
						$labels
					),

					"widget_title"	=> $widget["widget_name"],
				),

				$widget["mod_settings"]
			);

		}

		return "";		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OnePage() {
		global $base;

		//read all categories
		$cats = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND c.cat_date <= timestamp(now()) AND 
				c.cat_images > 0  
			ORDER BY  
				cat_order ASC 
			"
		);


		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l,

				{$this->tables['plugin:gallery_images']} as i,
				{$this->tables['plugin:gallery_images_lang']} as il
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND c.cat_date <= timestamp(now()) AND 
				c.cat_images > 0  AND 

				i.item_cat=c.cat_id AND 
				i.item_id=il.item_id AND 
				il.lang_id={$this->tpl_module[lang_id]} AND 
				i.module_id={$this->tpl_module[mod_id]} AND 
				item_show=1

			ORDER BY  
				cat_order ASC , item_order ASC
			"
		);

		$template = &$this->private->templates["onepage"];

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key] = $this->ProcessImage($val);

				$items[$key]["title"] = $this->tpl_module["settings"]["set_show_title"] ? $template->blockReplace("Title" , $val )  : "";
			}			
		}
		

		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);

		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"cats"	=> count($cats) > 1 ? $base->html->Table(
						$template, 
						"Cats" , 
						$cats
					) : "",

					"items"	=> $base->html->Table(
						$template, 
						"Photos" , 
						$items
					),

				),
				$text,	
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
					

	}

	

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		//multipage then build the subalbums links
		if ($module["settings"]["set_style"] != "onepage") {

			$items = $this->db->QFetchRowArray(
				"SELECT 
					cat_url , c.cat_id 
				FROM 
					{$this->tables['plugin:gallery_cats']} as c,
					{$this->tables['plugin:gallery_cats_lang']} as l
				WHERE
					c.cat_id=l.cat_id AND 
					l.lang_id={$module[lang_id]} AND 
					c.module_id={$module[mod_id]} AND 
					c.cat_status = 1 AND 
					c.cat_date <= timestamp(now()) AND 
					c.cat_images > 0  		
				"
			);


			if (is_array($items)) {
				foreach ($items as $key => $val) {
					$links[] = array(
						"url" => $module["link"] . $val["cat_url"] .  "-" . $val["cat_id"] . "/",
					);
				}
				
			}
		}

	}

}

?>