<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CMultiDropdown extends CPlugin{
	
	var $tplvars; 

	function CMultiDropdown() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$path = $this->tpl_path;

		$templates = array(
			"megamenu"			=> "megamenu.htm",
			"level"			=> "2level.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetMenuButton($module) {
		global $base;

		$this->__init();

		if ($module["settings"]["set_menus"]) {

			switch ($module["settings"]["set_display"]) {
				default: 
					$template = &$this->private->templates["megamenu"];
				break;

				case "2":
					$template = &$this->private->templates["level"];
				break;
			}
			

			$groups = explode("," , $module["settings"]["set_menus"]);

			if (count($groups)) {
				foreach ($groups as $key => $val) {
					$val = trim($val);
					if ($this->plugins["modules"]->modules[$val]) {
						$buttons[] = $this->plugins[$this->plugins["modules"]->modules[$val]["module_code"]]->GetMenuButton($this->plugins["modules"]->modules[$val]);
					}					
				}
				
			}
			
			if (is_Array($buttons)) {
				$cnt = 0;
				foreach ($buttons as $key => $val) {

					$sel = false;

					foreach ($val["sub"] as $k => $v) {
						if ($v["selected"]) {
							$selected = true;
							$sel = true;

							$val["sub"][$k]["selected"] = $template->BlockReplace("SubMenuSelected");
						} else {
							$val["sub"][$k]["selected"] = "";
						}
						
					}

					$buttons[$key]["selected"] =  $sel ? $template->BlockReplace("MenuSelected") : "";

					
					$buttons[$key]["items"] = $base->html->Table(
						$template , 
						"SubMenu" , 
						$val["sub"]
					);



					$cnt ++;
					$buttons[$key]["extra"] = "";

					if ($cnt == 4) {
						$cnt = 0;
						$buttons[$key]["extra"] = $template->blockReplace("Extra");
					}						


					
					
				}				


				$menu = $base->html->Table(
					$template,
					"Menu" , 
					$buttons
				);

			}
		
			
			return array(			
					"mod_id"	=> $module["mod_id"] ,
					"title"		=> $module["mod_name"],
					"link"		=> "#",//$module["link"],
					"selected"	=> $selected,
					"target"	=> "",

					"html"		=> $template->BlockReplace(
						"Main" , 
						array(
							"title"		=> $module["mod_name"],
							"mod_id"	=> $module["mod_id"],
							"menu"		=> $menu,
							"selected"	=> $selected ? $template->BlockReplace("Selected") : "",

						),
						$module["settings"]

					),
					"sub"		=> $submenu,
			);
		}
		

		
	}
	
}

?>