<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSkinEditor extends CPlugin{
	
	var $tplvars; 

	function CSkinEditor() {
		//$this->CPlugin($db, $tables , $templates);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "skineditor") {
			switch ($_GET["sub"]) {
				case "change":
					return $this->ChangeSkin();
				break;
			}
		}


		if ($_GET["submod"] == "currency") {
			return $this->CronTab();
		}

		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetSkin($mod_id , $system = false) {
		global $_CONF;


		if ($system) {
			$skin = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['core:skins']} WHERE find_in_set({$mod_id} , skin_modules_global) ORDER BY rand() limit 1"
			);
		} else {

			$skin = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['core:skins']} WHERE find_in_set({$mod_id} , skin_modules) ORDER BY rand() limit 1"
			);
		
		}

		
		if (!is_array($skin)) {
			$skin = array(
				"skin_base"	=> $this->vars->data["set_skin_style"],
				"skin_id"	=> $this->vars->data["set_skin"],
			);
		} else {
			$skin = array(
				"skin_base"	=> "assets/skins/" . $skin["skin_base"],
				"skin_id"	=> $skin["skin_id"]
			);
		}
		
		return $skin;
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetDefaultSkin() {

			return $skin = array(
				"skin_base"	=> $this->vars->data["set_skin_style"],
				"skin_id"	=> $this->vars->data["set_skin"],
			);
	}
	
	



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_SESS;

		//skin forced from admin
		if ($_SESS["skineditor"]) {
			$skin = array(
				"skin_base"	=> "assets/skins/" . $_SESS["skineditor"],
				"skin_id"	=> "preview"
			);
		} else {

			if ($_SESS["locale"]["skin"]) {
				$skin = array(
					"skin_id"	=> $_SESS["locale"]["skin"]
				);

			} elseif ($this->vars->data["set_skin_type"] == "1") {
				$skin = 	$this->plugins["skineditor"]->GetDefaultSkin();
			} else {

				if ($module["mod_id"]) {
					$skin = 	$this->plugins["skineditor"]->GetSkin($module["mod_id"]);
				} elseif ($module["module_id"]) {
					$skin = 	$this->plugins["skineditor"]->GetSkin($module["module_id"] , true);
				} else {
					//load default skin
					$skin = 	$this->plugins["skineditor"]->GetDefaultSkin();
				}
			}
		}

		global $_TSM;

		$_TSM["SKIN_PATH"] = $skin["skin_base"];

		if (file_exists('upload/skins/' . $skin['skin_id'] .'.css')) {
			$_TSM["PUB:SEO_CONV_HEAD"] .= '<link rel="stylesheet" href="{PRIV.BASE.HREF}upload/skins/' . $skin['skin_id'] .'.css{OPT_CSS_NOCACHE}">';		
		} 

		if (file_exists('upload/skins/overlays.css')) {
			$_TSM["PUB:SEO_CONV_HEAD"] .= '<link rel="stylesheet" href="{PRIV.BASE.HREF}upload/skins/overlays.css{OPT_CSS_NOCACHE}">';		
		} 

		$this->VisualSettings();		

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function VisualSettings() {

		global $_TSM;
				
		$_TSM["BODY-EXTRA-ATTR"] .= " data-menu-sticky=\"" . ($this->vars->data["set_menu_sticky"] ? "true" : "false") . "\" " ;
		$_TSM["BODY-EXTRA-CLASS"] .= " " . $this->vars->data["set_style_boxed"] . " ";
		$_TSM["BODY-EXTRA-CLASS"] .= " " . $this->vars->data["set_menu_style"]. " ";

		$_TSM["PUB:COPYRIGHT"] = "";

		if ($this->vars->data["set_copyright_bar"]) {
			$tmp = new CTemplateDynamic($this->tpl_path . "copyright.htm");

			$_TSM["PUB:COPYRIGHT"] = $tmp->blockReplace("Footer" , $_TSM);
		}

		if ($this->vars->data["set_preloader"]) {
			$tmp2 = new CTemplateDynamic($this->tpl_path . "preloader.htm");
			$this->plugins["seo"]->PrependToBody($tmp2->blockReplace("Main"));
		}


	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ChangeSkin() {
		global $_SESS , $_CONF;

		if ($_GET["skin_id"] == "remove") {
			if (isset($_SESS["locale"])) {
				unset($_SESS["locale"]["skin"]);
			}
			
		} elseif ($_GET["skin_id"] && is_array($skin = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:skins']} WHERE skin_id=%d" , array($_GET["skin_id"]))) ) {
			$_SESS["locale"]["skin"] = $skin["skin_id"];
		}
		
		urlredirect($_CONF["url"]);
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Overlay($id) {
		if ($id > 0) {
			return "overlay-class overlay-class-{$id}";
		}		
	}
	
}

?>