<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTimeline extends CPlugin{
	
	var $tplvars; 

	function CTimeline() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name = "timeline";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "ajax.load":
					return $this->AjaxLoad();
				break;				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			//return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"landing"				=> "landing.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);

			
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			)
		);

		//get all the items

		$items = $this->GetItems(array(
			"items"	=> $this->tpl_module["settings"]["set_ipp_items"],
			"page"	=> "0"
		));


		$items["records"] = $this->ProcessItems($items["records"]);

		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}


		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$this->private->templates["landing"]->blockREplacE(
				"Main" , 
				array(
					"content"	=> $base->html->table(
						$this->private->templates["landing"],
						"" ,
						$items["records"]
					),

					"script"	=> $this->plugins["modules"]->ScriptLink("timeline.ajax.load.php" , array("module_id" => $this->tpl_module["mod_id"])),

					"extra"	=> $items["pages"] <= $items["page"] ? $this->private->templates["landing"]->blockREplace("EmptyTopics") : ""

				),
				$text,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
	}


	/**
	* description

	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetItems($params = array()) {
	
		$count	= $params["items"];
		$page	= $params["page"];

		$order		= "item_date";
		$order_mode = $this->tpl_module["settings"]["set_sort"] == "desc" ? "DESC"  :"ASC";

		$cond = "t.module_id={$this->tpl_module[mod_id]} AND t.item_id = l.item_id AND l.lang_id = {$this->tpl_module[lang_id]}";

				
		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:timeline_items']} as t,
				{$this->tables['plugin:timeline_items_lang']} as l
			",
			"	WHERE {$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:timeline_items']} as t,
				{$this->tables['plugin:timeline_items_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items) {

		$tpl = &$this->private->templates["landing"];

		$year = 0;

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$val["year"] = date("Y" , $val["item_date"]);

				if ($val["year"] != $year) {
					$items[$key]["extra"] = $tpl->blockReplace("Year" , array("year" => $val["year"]) );
					$year = $val["year"];
				}  else {
					$items[$key]["extra"] = "";
				}
				

				$items[$key]["title"] = $val["item_title"] ? $tpl->blockReplace("Title" , $val) : "";
				$items[$key]["body"] = $val["item_body"] ? $tpl->blockReplace("Body" , $val) : "";


				switch ($val["item_link_type"]) {
					case "0":
						$more = "";
					break;

					case "1":
						$more = $tpl->blockReplace(
							"Link",
							array(
								"link"		=> $val["item_link_link"],
								"target"	=> $val["item_link_target"],
								"text"		=> $val["item_link_text"],
							)
						);
					break;

					case "2":


						if (is_array($this->plugins["modules"]->modules[$val["item_link_module"]])) {
							$more = $tpl->blockReplace(
								"Link",
								array(
									"link"		=> $this->plugins["modules"]->modules[$val["item_link_module"]]["link"],
									"target"	=> $val["item_link_target"],
									"text"		=> $val["item_link_text"],
								)
							);
						}						
					break;
				}

				switch ($val["item_type"]) {
					case "0":
						$items[$key]["resource"] = "";
					break;

					case "1":
						$items[$key]["resource"] = $tpl->blockReplace("Image" , $val);
					break;

					case "2":
						$items[$key]["resource"] = $tpl->blockReplace("Youtube" , $val);
					break;

					case "3":
						$items[$key]["resource"] = $tpl->blockReplace("Vimeo" , $val);
					break;

				
					case "4":
						$items[$key]["resource"] = $tpl->blockReplace("Audio" , $val);
					break;

				}
				

				$items[$key]["link"] = $more;


				$items[$key]["date"] = date($this->tpl_module["settings"]["set_date"] , $val["item_date"]);
			}
			
		}
		
		return $items;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AjaxLoad() {
		global $base;

		$items = $this->GetItems(array(
			"items"	=> $this->tpl_module["settings"]["set_ipp_items"],
			"page"	=> $_POST["page"]
		));

		$items["records"] = $this->ProcessItems($items["records"]);

		if (!is_array($items["records"])) {
			die("");
		}	

		return $this->private->templates["landing"]->blockREplacE(
			"Ajax" , 
			array(
				"content"	=> $base->html->table(
					$this->private->templates["landing"],
					"" ,
					$items["records"]
				),
				"extra"	=> $items["pages"] <= $items["page"] ? $this->private->templates["landing"]->blockREplace("EmptyTopics") : ""
			)
		);


	}
	
}

?>