<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CNews extends CPlugin{
	
	var $tplvars; 

	function CNews() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "news") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "item":
					return $this->Item();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"list"					=> "list.htm",

			"item"					=> "item.htm",
			"image"					=> "image.htm",

			"widget"				=> "widget.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 



	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->widgetNews($widget);
			break;
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetNews($widget) {

		$this->__init();

		$cnt = max(1, $widget["settings"]["set_items"]);

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:news_items']} as t , {$this->tables['plugin:news_items_lang']} as l 
			WHERE t.module_id = {$widget[mod_id]} AND l.lang_id={$widget[lang_id]} AND t.item_id=l.item_id 
			ORDER BY item_date DESC
			LIMIT $cnt
			"
		);

		if (is_array($items)) {

			global $base;
			$template = &$this->private->templates["widget"];

			foreach ($items as $key => $val) {
				$items[$key]["image"] = $template->blockReplace($val["item_tn"] ? "Photo" : "NoPhoto" , $val);
				$items[$key]["link"] = $widget["link"] .  $val["item_id"] . "-" . $val["item_url"];
				$items[$key]["item_brief"] = substr(strip_tags($val["item_brief"]) , 0, $widget["settings"]["set_chars"]) . "[...]";
				$items[$key]["date"]	= CDate::ToStr("jS F Y" , $val["item_date"]);
				$items[$key]["author"] = $val["item_author"] ? $template->blockReplace("Author" , $val) : "";
			}
			

			return $template->blockReplace(
				"Main" , 
				array(
					"news"	=> $base->html->table(
						$template , 
						"" , 
						$items
					)
				),
				$widget,
				$widget["mod_settings"]
			);
		}
		
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->getTexts();

		$this->plugins["seo"]->PageMeta(
			array(
				"seo_title"	=> CtemplateStatic::Replace( $text[$_GET["page"] > 1 ? "seo_title_page" :  "seo_title"] , array ( "page" => (int)$_GET["page"] )),
				"seo_desc"	=> $text[$_GET["page"] > 1 ? "seo_desc_page" :  "seo_desc"],
			)
		);

			
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> 	$text["text_title"],
				"subtitle"	=> 	$text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);

		$items = $this->GetItems(array(
			"items"		=> $this->tpl_module["settings"]["set_ipp_items"] , 
			"page"		=> $_GET["page"]
		));

		$items["records"] = $this->ProcessItems($items["records"] , $items);

		$template = &$this->private->templates["list"];

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$items["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$items["pages"] , 
						$items["page"] , 
						array(
							"first"	=> $this->tpl_module["link"] ,
							"all"	=> $this->tpl_module["link"] . "p{PAGE}",
						),
						$items["items"]
					),

					"text_title"	=> CtemplateStatic::Replace($text[$_GET["page"] >  1 ? "text_title_page" : "text_title"] , array("page" => $_GET["page"])),
				),
				$text ,
				$this->tpl_module,
				$this->tpl_module["settings"]		
			)
		);

	}

		
	

	function GetItems($params = array()) {
	
		$count	= max(2,$params["items"]);
		$page	= $params["page"];

		$order		= "item_date";
		$order_mode = "desc";


		$cond = " c.item_id=l.item_id AND l.lang_id={$this->tpl_module[lang_id]} AND c.module_id={$this->tpl_module[mod_id]} AND item_status=1 AND item_date <=  " . time() ;

		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:news_items']} as c,
				{$this->tables['plugin:news_items_lang']} as l
			",
			"	WHERE {$cond}"
		);


		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:news_items']} as c,
				{$this->tables['plugin:news_items_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items , $category) {

		$template = &$this->private->templates["list"];


		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$val["link"] = $items[$key]["link"] = $this->tpl_module["link"] . $val["item_id"] . "-" . $val["item_url"] ;

				if ($val["item_author"]) {
					$items[$key]["author"] = $template->blockReplace(
						"Author" , 
						$val
					);
				} else {
					$items[$key]["author"] = "";
				}

				if ($this->tpl_module["settings"]["set_comments"] > 0) {
					$val["item_stats_comments"] = $this->plugins["comments"]->CommentsCount(
						$this->tpl_module["settings"]["set_comments"],
						$val["link"],
						$val["item_stats_comments"]
					);
					$items[$key]["data_comments"] = $template->blockReplace("Comments" , $val);
				} else {
					$items[$key]["data_comments"] = "";
				}

				$items[$key]["social_links"] = $this->plugins["socialmedia"] ? $this->plugins["socialmedia"]->Share($val["link"]) : "";
				
				
				$items[$key]["img"] = $this->ItemImage($val , "list");
								
				$items[$key]["date"] = CDate::ToStr("M jS Y" ,$val["item_date"]);

				$items[$key]["day"] = CDate::ToStr("d" ,$val["item_date"]);
				$items[$key]["month_3"] = CDate::ToStr("M" ,$val["item_date"]);
				$items[$key]["month"] = CDate::ToStr("F" ,$val["item_date"]);
				$items[$key]["year"] = CDate::ToStr("Y" ,$val["item_date"]);;
				
			}			
		}
		

		return $items;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ItemImage($item , $type) {
		global $_LANG_ID;

		$template = &$this->private->templates["image"];

		switch ($type) {
			case "list":

				if (!$item["item_image"]) {
					return "";
				}

				if ($item["item_image"] == "1") {

					$items = $this->db->QFetchROwArray(
						"
						SELECT * FROM 
							{$this->tables['plugin:news_images']} as r,
							{$this->tables['plugin:news_images_lang']} as l
						WHERE
							r.item_id = l.item_id AND 
							r.item_parent = {$item['item_id']} AND 
							l.lang_id = {$_LANG_ID} 

						ORDER BY 
							item_order ASC
						LIMIT 
							1
						"
					);
				} else {
					$items = $this->db->QFetchROwArray(
						"
						SELECT * FROM 
							{$this->tables['plugin:news_images']} as r,
							{$this->tables['plugin:news_images_lang']} as l
						WHERE
							r.item_id = l.item_id AND 
							r.item_parent = {$item['item_id']} AND
							l.lang_id = {$_LANG_ID} 
						ORDER BY 
							item_order ASC
						"
					);
				}								
			break;

			case "details":

				if (!$item["item_image_details"]) {
					$items = $this->db->QFetchROwArray(
						"
						SELECT * FROM 
							{$this->tables['plugin:news_images']} as r,
							{$this->tables['plugin:news_images_lang']} as l
						WHERE
							r.item_id = l.item_id AND 
							r.item_parent = {$item['item_id']} AND
							l.lang_id = {$_LANG_ID}

						ORDER BY 
							item_order ASC
						"
					);
				}
			break;
		}
		


		if (!is_array($items)) {
			return "";
		}

		if (count($items) == 1) {
			//simple image / video / youtube

			switch ($items[0]["item_type"]) {

				//image
				case "1":
					$return  = $template->BlockReplace(
						"Image" , 
						$items[0],
						array(
							"copy"	=> ($type == "details") && $items[0]["item_author"] ? $template->blockReplace("Copyright" , $items[0]) : "",
							"title"	=> $items[0]["item_title"] ? $template->blockReplace("Title" , $items[0]) : ""
						)
					);
				break;

				//youtube
				case "2":
					$return  = $template->BlockReplace(
						"Youtube" , 
						$items[0]
					);
				break;

				//vimeo
				case "3":
					$return  = $template->BlockReplace(
						"Vimeo" , 
						$items[0]
					);
				break;

				//audio
				case "4":
					$return  = $template->BlockReplace(
						"Audio" , 
						$items[0]
					);
				break;

			}
			
		} else {
			$block = "Slider";

			//image slider 
			global $base;

			foreach ($items as $key => $val) {

				switch ($val["item_type"]) {
					case "1": 
						$val["copy"] = ($type == "details") && $val["item_author"] ? $template->blockReplace("Copyright" , $val) : "";
						$items[$key]["content"] = $template->blockReplace("{$block}Image" , $val); 
					break;

					case "2": $items[$key]["content"] = $template->blockReplace("{$block}Youtube" , $val); break;
					case "3": $items[$key]["content"] = $template->blockReplace("{$block}Vimeo" , $val); break;
					case "4": $items[$key]["content"] = $template->blockReplace("{$block}Audio" , $val); break;
				}
				
			}
			
			$return  = CTemplateStatic::Replace(
				$base->html->Table(
					$template , 
					"{$block}" , 
					$items
				),
				array(
					"count"	=> count($items),
					"item_parent"	=> $item["item_id"]
				)
			);
		}


		if ($return) {

			return  CTemplateStatic::Replace(
				$return,
				array(
					"link"	=> $item["link"],
				)
			);

		}
				
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Item() {

		$item = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:news_items']} as i,
				{$this->tables['plugin:news_items_lang']} as il
			WHERE
				i.item_id = il.item_id AND 
				il.lang_id = {$this->tpl_module[lang_id]} AND 
				i.item_id = {$_GET[item_id]} AND 
				i.item_status = 1 AND 
				i.item_date <= timestamp(now())
			"
		);

		if (!is_array($item)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$item["link"] = $this->tpl_module["link"] . $item["item_id"] . "-" . $item["item_url"];

		$this->module->plugins["seo"]->PageMeta(
			$item
		);

		$template = &$this->private->templates["item"];

		$item["img"] = $this->ItemImage($item , "details");
		$item["date"] = CDate::ToStr("jS M Y" ,$item["item_date"]);
		$item["day"] = CDate::ToStr("d" ,$item["item_date"]);
		$item["month_3"] = CDate::ToStr("M" ,$item["item_date"]);
		$item["month"] = CDate::ToStr("F" ,$item["item_date"]);
		$item["year"] = CDate::ToStr("Y" ,$item["item_date"]);;

		$item["homepage"] = $this->tpl_module["link"];


		if ($item["item_author"]) {
			$item["author"] = $template->blockReplace(
				"Author" , 
				$item
			);
		} else {
			$item["author"] = "";
		}

		$item["social_links"] = $this->plugins["socialmedia"] ?$this->plugins["socialmedia"]->Share($item["link"]) : "";

		if ($item["item_source"]) {

			if ($item["item_source_btn"]) {
				$source_name = $item["item_source_btn"];
			} else {

				$tmp = parse_url($item["item_source"]);
				$source_name = $tmp["host"];
			}
			

			$item["source"] = $template->blockreplace(
				"Source" , 
				$item,
				array(
					"src_short"	=> $source_name
				)
			);
		} else {
			$item["source"] = "";
		}


		$text = $this->getTexts();

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> 	$text["text_title"],
				"subtitle"	=> 	$text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
				$this->tpl_module["link"] . "{$item[item_id]}-{$item[item_url]}"	=> $item["item_title"],
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);



		$item["next_link"] = $this->ItemLink($item , "next");
		$item["back_link"] = $this->ItemLink($item , "back");


		$item["next"] = $item["next_link"] ? $template->blockReplace("Next" , $item) : "";
		$item["back"] = $item["back_link"] ? $template->blockReplace("Back" , $item) : "";

		
		if (is_object($this->module->plugins["comments"])) {


			if ($this->tpl_module["settings"]["set_comments"] == "2") {
				$item["item_stats_comments"] = $this->plugins["comments"]->FacebookCommentsCount($item["link"]);
			}

			$item["comments"] = $this->module->plugins["comments"]->Comments(
				$item["link"],
				$this->tpl_module["settings"]["set_comments"],
				!$item["item_comments_new"],
				array(
					"module"	=> $this->tpl_module["mod_id"],
					"reserved"	=> $item["item_id"],
				)
			);

			$item["data_comments"] = $template->blockReplace("Comments" , $item);
		}
		



		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_item"],
				$this->tpl_module["mod_protected"]
			),
			CTemplateStatic::Replace(
				$template->blockREplacE(
					"Main" , 
					$item
				),
				$this->tpl_module["settings"]
			)			
		);	
	}

	
	function ItemLink($parent , $type) {

		switch ($type) {
			case "next":

				$item = $this->db->QFetchArray(
					"SELECT * FROM 
						{$this->tables['plugin:news_items']} as i,
						{$this->tables['plugin:news_items_lang']} as il
					WHERE
						i.item_id = il.item_id AND 
						il.lang_id = {$this->tpl_module[lang_id]} AND
						i.item_id > {$parent[item_id]}

					ORDER BY 
						i.item_id ASC 
					LIMIT 1
					"
				);

				if (!is_array($item)) {			
					return ""; //$this->tpl_module["link"] ;
				} else {
					return $this->tpl_module["link"] . $item["item_id"] . "-" . $item["item_url"] ;
				}				
			break;

			case "back":

				$item = $this->db->QFetchArray(
					"SELECT * FROM 
						{$this->tables['plugin:news_items']} as i,
						{$this->tables['plugin:news_items_lang']} as il
					WHERE
						i.item_id = il.item_id AND 
						il.lang_id = {$this->tpl_module[lang_id]} AND
						i.item_id < {$parent[item_id]}

					ORDER BY 
						i.item_id DESC
					LIMIT 1
					"
				);

				if (!is_array($item)) {			
					return "";//$this->tpl_module["link"] ;
				} else {
					return $this->tpl_module["link"] . $item["item_id"] . "-" . $item["item_url"] ;
				}				

			break;
		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCommentPost($comment) {

		$this->db->QueryUpdate(
			$this->tables["plugin:news_items"],
			array(
				"item_stats_comments"	=> $this->db->RowCount(
					$this->tables["plugin:comments"],
					"WHERE module_id={$comment[module_id]} AND comment_reserved={$comment[comment_reserved]}" 
				)
			),
			"item_id={$comment[comment_reserved]}"
		);
	}
	


	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		$items = $this->db->QFetchRowArray(
			"SELECT 
				c.item_id , item_date , item_url 
			FROM 
				{$this->tables['plugin:news_items']} as c,
				{$this->tables['plugin:news_items_lang']} as l
			WHERE 					
				c.item_id=l.item_id AND 
				l.lang_id={$module[lang_id]} AND 
				c.module_id={$module[mod_id]} AND 
				item_status=1 AND 
				item_date <=  " . time()				
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"lastmod"	=> $val["item_date"],
					"url"		=> $module["link"] . $val["item_id"] . "-" . $val["item_url"] 
				);
			}
			
		}
		
	}

}

?>